﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PointClass
{
    /// <summary>
    /// Klasa Point zawiera 2 właściwości, 1 przeciążony 
    /// konstruktor i jedną przeciążoną metodę.
    /// </summary>
    /// <remarks>
    /// Jeżeli musimy użyć klasy Point z przestrzeni nazw
    /// System.Drawing, to należy odwoływać się do niej
    /// poprzez jej pełną nazwę, czyli System.Drawing.Point.
    /// </remarks>
    /// <history>
    /// [Wei-Meng Lee]   5/12/2008   Utworzone
    /// </history>
    public class Point
    {
        //---zmienna statyczna---
        private static int count;

        //---właściwości---
        /// <summary>
        /// Właściwość dla współrzędnej X
        /// </summary>
        /// <returns>
        /// Współrzędna X
        /// </returns>
        public int x { get; set; }

        /// <summary>
        /// Właściwość dla współrzędnej Y
        /// </summary>
        /// <returns>
        /// Współrzędna Y
        /// </returns>
        public int y { get; set; }

        //---konstruktory---
        /// <summary>
        /// Konstruktor domyślny
        /// </summary>
        /// <remarks>
        /// Tworzy nowy obiekt klasy Point.
        /// </remarks>
        public Point()
        {
            count++;
        }

        /// <overloads>
        /// Konstruktor
        /// </overloads>
        /// <summary>
        /// Konstruktor z dwoma parametrami
        /// </summary>
        /// <param name="x">Parametr x przypisywany jest do współrzędnej X</param>
        /// <param name="y">Parametr y przypisywany jest do współrzędnej Y</param>
        /// <remarks>
        /// Tworzy nowy obiekt klasy Point.
        /// </remarks>
        public Point(int x, int y)
        {
            this.x = x;
            this.y = y;
            count++;
        }

        //---metody przeciążone---
        /// <overloads>
        /// Wylicza odległość pomiędzy dwoma punktami
        /// </overloads>
        /// <summary>
        /// Wylicza odległość punktu od początku układu współrzędnych
        /// </summary>
        /// <returns>
        /// Odległość między aktualnym punktem, a początkiem układu współrzędnych
        /// </returns>
        /// <example> Przykład wywołania metody <c>Length()</c> 
        /// <code>
        ///    Point ptA = new Point(3, 4);
        ///    double distance = ptA.Length();
        /// </code>
        /// </example>
        public double Length()
        {
            return Math.Sqrt(
                Math.Pow(this.x, 2) +
                Math.Pow(this.y, 2));
        }
        
        /// <summary>
        /// Wylicza odległość aktualnego punktu od punktu podanego w parametrze
        /// </summary> 
        /// <param name="pt">Obiekt klasy Point</param>
        /// <returns>Odległość aktualnego punktu od punktu podanego w parametrze
        /// </returns>
        /// <example> Przykład wywołania metody <c>Length()</c>
        /// z podanym w parametrze punktem.
        /// <code>
        ///    Point ptA = new Point(3, 4);
        ///    Point ptB = new Point(7, 8);
        ///    double distance = ptA.Length(ptB);
        /// </code>
        /// </example>
        public double Length(Point pt)
        {
            return Math.Sqrt(
                Math.Pow(this.x - pt.x, 2) +
                Math.Pow(this.y - pt.y, 2));
        }
    }
}
